
(defmeth browser-overlay-proto :setup-redraw ()
  (when (slot-value 'graph)
  (let* ((graph (slot-value 'graph))
         (editable (send graph :editable))
;list of all button names - includes all possible buttons
;regardless of whether the button appears
         (string (list "Help" 
                       (if (equal 'active (send self :retain-edit))    "Retain"   "Edit")
                       (if (equal 'active (send self :discard)) "Discard" "Close")

                      
                       "Format" 
                       "Expand"
                       "Labels"

                       "Selector"
                       "OnTop"
                       (if (send self :max-state)  "Maximize" "Restore")
                       ))
         (short-string string)
         
;list of t/nil determining which buttons appear
         (buttons 
          (list (send self :help)   
                (send self :retain-edit)
                (send self :discard)

                (send self :format)
                (send self :expand)
                (send self :labels) 

                
                (send self :selector)`
                (send self :top-most)
                (send self :maximize-button-showing)
                ))
         (bar (send self :setup-redraw-button-bar string buttons short-string 0)) 
         (lefts (first bar))
         (strings (second bar))
         )
    (send self :num-top-buttons (length (first bar)))
    (send self :lefts (first bar))
    (send self :strings (second bar))
    (send self :buttons (remove 'nil buttons))
    )))

(defmeth browser-overlay-proto :redraw-the-overlay () 
  (send self :redraw))



(defmeth browser-overlay-proto :redraw ()
  (when (send (slot-value 'graph) :button-bar-showing?)
  (unless (send self :lefts) 
          (send self :setup-redraw))
  (let* ((graph (slot-value 'graph))
         (draw-color (send graph :draw-color))
         (button-color 'black)
         (color-mode *color-mode*)
         (vr (send graph :view-rect))
         (lefts (send self :lefts))
         (strings (send self :strings))
         (two-tw 0)
         (three-tw 0)
         (dff )
         (i 0)
         (topy 3)
         (height 10)
         (width  10)
         (gap 2)
         (save-color 'black)
         (center (send self :justify))
         (td (send graph :text-descent))
         (retain-edit-color 'grey1)
         (discard-close-color 'grey1)
         (visible-color 'grey1)
         (active-color 'red)
         (bottom-of-top (- (second (send graph :margin)) 3))
         (idling (send graph :idle-on))
         (nbuts (send self :num-top-buttons))
         (nbutbox1 (length (remove 'nil 
             (list (send self :help) (send self :retain-edit) 
                   (send self :discard)))))
         (nbutbox2 (length (remove 'nil
             (list (send self :format) (send self :selector) 
                   (send self :expand) (send self :labels)))))
         (nbutbox3 (length (remove 'nil 
             (list (send self :max)  (send self :top)))))
         (stringlist (select strings (iseq nbutbox1)))
         (offset1 0)
         (box-left1 3)
         (box-width1 
          (if (> nbutbox1 0) 
              (sum (mapcar #'(lambda (string) (+ 17 (send graph :text-width string)))
                             stringlist)) 0))
         (stringlist (select strings (iseq nbutbox1 (+ nbutbox1 nbutbox2 -1))))
         (offset2 10)
         ;(box-left2 (+ box-left1 box-width1 offset2))
         (box-width2 
           (if (> nbutbox2 0) 
              (sum (mapcar #'(lambda (string) (+ 17 (send graph :text-width string)))
                             stringlist)) 0))
         (box-left2 (floor (/ (- (first (send graph :size)) box-width2) 2)))
         (box-left2 (max (floor (/ (- (first (send graph :size)) box-width2) 2))
                         (+ box-left1 box-width1 15)))
         (offset2 (- box-left2 box-width1 3))
         (stringlist (select strings (iseq nbutbox1)))
         
         (box-width3 0) 
         
         (boxes (send self :justify))
         (justify (send self :justify))
         (offset3 0)
         )
    (unless (or (= 0 (third vr)) (= 0 (fourth vr)))
            (when (not color-mode) (send graph :use-color nil))
            (when (or (not (send self :old-canvas-width));fwy!
                      (/= (send self :old-canvas-width) ;fwy!
                          (send graph :canvas-width)));fwy!
                  (send self :old-canvas-width 
                        (send graph :canvas-width));fwy!
                  (setf lefts nil) ;fwy!
                  (send self :lefts nil));fwy!
            (when (not lefts) 
                  (send self :setup-redraw)
                  (setf lefts (send self :lefts))
                  (setf strings (send self :strings))
                  )

            (if (and color-mode (send *vista* :background-color))
                (send graph :draw-color 'toolbar-background)
                (send graph :draw-color 'white))
            (send graph :paint-rect 
                  (first vr) (second vr) (third vr) bottom-of-top)
            (send graph :draw-color draw-color)
            (send graph :draw-line (first vr) (+ (second vr) bottom-of-top)
                  (+ (first vr) (third vr))
                  (+ (second vr) bottom-of-top))  


;first button-group help retain-edit discard-close

            (when boxes (send self :draw-button-box box-left1 box-width1) )

            (setf i (send self :draw-button-group
                          (list (send self :help) (send self :retain-edit)
                                (send self :discard)) 
                          i
                          offset1))

;second button-group - format expand labels select

            (when boxes (send self :draw-button-box box-left2 box-width2) )

            (setf i (send self :draw-button-group
                          (list (send self :format) (send self :expand)
                                (send self :labels) (send self :selector))
                          i
                          offset2))

;third button-group - ontop max-restore            

            (when (or (send self :top-most)
                      (send self :maximize-button-showing))
                  (setf j (1- i))
                  (setf box-right (- (first (send graph :size)) 12))
                  (setf box-left box-right)
                  (when (send self :top-most)
                        (setf j (1+ j))
                        (setf box-left (- box-left 17 
                                          (send graph :text-width (select strings j)))))
                  (when (send self :maximize-button-showing)
                        (setf j (1+ j))
                        (setf box-left (- box-left 17 
                                          (send graph :text-width (select strings j)))))
                  (setf box-width (- box-right box-left))
                  (when (< box-left (+ 20 (select lefts i)) )
                        (setf box-left (+ 30 (select lefts i))))
                  (when boxes (send self :draw-button-box box-left box-width))

                  (setf offset3 (if (send self :justify)
                                   (- box-left -3 (select lefts i)) 0))
                  
                  (setf i (send self :draw-button-group
                                (list (send self :top-most) (send self :maximize-button-showing))
                                i
                                offset3))
                  )
            ))))
     



#|
 | NIL
 | 'VISIBLE 
 | 'READY
 | 'ACTIVE
 |#

(defmeth browser-overlay-proto :draw-button-group (buttons i offset)
  (let* ((graph (send self :graph))
         (vr (send graph :view-rect))
         (lefts (send self :lefts))
         (button-color)
         (text-color)
         (visible-color 'grey1)
         (ready-color 'black)
         (active-color 'red)
         )
    (mapcar #'(lambda (button-state)
                (unless (equal nil button-state)
                        (case button-state
                          (t (setf button-color ready-color)
                             (setf text-color ready-color))
                          ('visible (setf button-color visible-color)
                                    (setf text-color visible-color))
                          ('ready   (setf button-color ready-color)
                                    (setf text-color ready-color))
                          ('active  (setf button-color active-color)
                                    (setf text-color ready-color)
                                    (send graph :line-width 2)))
                        (setf (select lefts i) (+ (select lefts i) offset))
                        (send self :draw-button nil i :vr vr 
                              :button-color button-color :text-color text-color)
                        (setf (select lefts i) (- (select lefts i) offset))
                        (send graph :draw-color 'black)
                        (send graph :line-width 1)
                        (setf i (1+ i))
                        ))
            buttons)
    i))



(defmeth browser-overlay-proto :draw-button-box (l w)
  (let* ((graph   (slot-value 'graph))
         (vr      (send graph :view-rect))
         (rect    (list (+ (first vr) l )
                        (+ (second vr) 1) 
                        w
                        15)))
    (send graph :draw-color 'light-yellow)
    (apply #'send graph :paint-rect rect)
    (send graph :draw-color 'black)
    (apply #'send graph :frame-rect rect)
    t))


                     
(defmeth browser-overlay-proto :draw-button-box2 (i j dff)
  (let* ((lefts   (send self :lefts)))
    (setf (select lefts i) (+ (select lefts i) dff))
    (setf (select lefts j) (+ (select lefts j) dff))
    (let* ((graph   (slot-value 'graph))
           (vr      (send graph :view-rect))
           (strings (send self :strings))
           (widthj  (send graph :text-width 
                          (remove-trailing-blanks 
                           (select strings j))))
           (loc1    (+ (select lefts i)))
           (loc2    (+ (select lefts j) widthj 17))
           (rect    (list (+ (first vr) -2 loc1 )
                          (+ (second vr) 1) 
                          (- loc2 loc1) 
                          15))
           )
      (send graph :draw-color 'light-blue)
      (apply #'send graph :paint-rect rect)
      (send graph :draw-color 'black)
      (apply #'send graph :frame-rect rect))
    (setf (select lefts i) (- (select lefts i) dff))
    (setf (select lefts j) (- (select lefts j) dff))
    t))